<?php

namespace App\Filament\Admin\Resources\AboutSectionFinals\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class AboutSectionFinalsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('icon')
                    ->label('Ícono')
                    ->searchable(),
                TextColumn::make('titleicon')
                    ->label('Título Ícono')
                    ->searchable(),
                TextColumn::make('subtitleicon')
                    ->label('Subtítulo Ícono')
                    ->searchable(),
                ImageColumn::make('image')
                    ->label('ícono imagen'),
                TextColumn::make('title')
                    ->label('Título')
                    ->searchable(),
                TextColumn::make('description')
                     ->label('Descripción')
                     ->searchable(),
                TextColumn::make('buttontext')
                    ->label('Texto Botón')
                    ->searchable(),
                TextColumn::make('buttonlink')
                    ->label('URL Botón')
                    ->searchable(),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make()
                    ->iconButton(),
                DeleteAction::make()
                    ->iconButton(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
