<?php

namespace App\Filament\Admin\Resources\BannerHomes\Pages;

use App\Filament\Admin\Resources\BannerHomes\BannerHomeResource;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditBannerHome extends EditRecord
{
    protected static string $resource = BannerHomeResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function getRedirectUrl(): string
    {
        // Esto redirige a la página de listado
        return $this->getResource()::getUrl('index');
    }
}
