<?php

namespace App\Filament\Admin\Resources\BannerHomes\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class BannerHomeForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('title')
                    ->label('Título')
                    ->required(),
                TextInput::make('caption')
                    ->label('Subtitulo')
                    ->required(),
                FileUpload::make('image')
                    ->label('Imagen (2892x1303 px)')
                    ->image()
                    ->required(),
            ]);
    }
}
