<?php

namespace App\Filament\Admin\Resources\Offers\Pages;

use App\Filament\Admin\Resources\Offers\OfferResource;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditOffer extends EditRecord
{
    protected static string $resource = OfferResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function getRedirectUrl(): string
    {
        // Esto redirige a la página de listado
        return $this->getResource()::getUrl('index');
    }
}
