<?php

namespace App\Filament\Admin\Resources\Properties\Pages;

use App\Filament\Admin\Resources\Properties\PropertyResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Notifications\Notification;

class CreateProperty extends CreateRecord
{
    protected static string $resource = PropertyResource::class;

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('view', ['record' => $this->getRecord()]);
    }

    // Mensaje de éxito personalizado
    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->title('Inmueble creado exitosamente')
            ->body('Ahora puedes agregar imágenes y características.');
    }

    // Mensaje después de guardar
    protected function afterCreate(): void
    {
        Notification::make()
            ->success()
            ->title('¡Siguiente paso!')
            ->body('Agrega las imágenes del inmueble en la pestaña "Imágenes"')
            ->persistent()
            ->send();
    }
}
