<?php

namespace App\Filament\Admin\Resources\Properties\Pages;

use App\Filament\Admin\Resources\Properties\PropertyResource;
use Filament\Actions\EditAction;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\ViewRecord;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Schemas\Schema;
use App\Filament\Admin\Resources\Properties\Schemas\PropertyInfolist;
use Filament\Notifications\Notification;

class ViewProperty extends ViewRecord implements HasTable
{
    use InteractsWithTable;
    
    protected static string $resource = PropertyResource::class;

    public function schema(Schema $schema): Schema
    {
        return PropertyInfolist::configure($schema);
    }

    // ✅ Escuchar notificaciones desde Livewire hijo
    protected function getListeners(): array
    {
        return array_merge(parent::getListeners(), [
            'notify' => 'handleNotify',
        ]);
    }

    // ✅ SOLUCIÓN: Recibir como array
    public function handleNotify(array $data): void
    {
        $type = $data['type'] ?? 'info';
        $message = $data['message'] ?? 'Operación realizada';
        
        // Mapear tipos de Livewire a Filament
        $filamentType = match($type) {
            'success' => 'success',
            'danger', 'error' => 'danger',
            'warning' => 'warning',
            default => 'info',
        };
        
        Notification::make()
            ->title($message)
            ->{$filamentType}()
            ->send();
    }

    protected function getHeaderActions(): array
    {
        return [
            EditAction::make(),
            DeleteAction::make(),
        ];
    }
}