<?php

namespace App\Filament\Admin\Resources\Properties\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;

class PropertiesTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('code')
                    ->label('Código')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('state')
                    ->badge()
                    ->colors([
                        'primary',
                        'success' => 'Activo',
                        'danger' => 'Inactivo',
                    ]),    
                TextColumn::make('offer.name')
                    ->label('Oferta')
                    ->searchable()
                    ->badge()
                    ->colors([
                        'primary',
                        'success' => 'Arriendo',
                        'warning' => 'Venta',
                    ])
                    ->sortable(),
                TextColumn::make('propertyStatus.name')
                    ->label('Estado del Inmueble')
                    ->badge()
                    ->colors([
                        'primary',
                        'success' => 'Destacado',
                        'warning' => 'Arrendado',
                        'danger' => 'Vendido',
                        'primary' => 'Disponible',
                    ])
                    ->sortable(),   
                TextColumn::make('typeProperty.name')
                    ->label('Tipo de Inmueble')
                    ->sortable(),
                TextColumn::make('agent.name')
                    ->label('Agente')
                    ->sortable(),   
                TextColumn::make('price')
                    ->label('Precio')
                    ->formatStateUsing(function ($state) {
                        return '$ ' . number_format($state, 0, ',', '.') . ' COP';
                    })
                    ->sortable(),
                TextColumn::make('administration')
                    ->label('Administración')
                    ->formatStateUsing(function ($state) {
                        return '$ ' . number_format($state, 0, ',', '.') . ' COP';
                    })
                    ->sortable(),   
                TextColumn::make('address')
                    ->label('Dirección')
                    ->formatStateUsing(function ($state): string {
                        if (empty($state)) {
                            return 'Sin dirección';
                        }
                        
                        // Explode por coma y tomar el primer elemento
                        $parts = explode(',', $state);
                        return trim($parts[0]);
                    })
                    ->sortable(),   
                TextColumn::make('address_extra')
                    ->label('Dirección Extra'),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                ViewAction::make()
                    ->iconButton(),
                EditAction::make()
                    ->iconButton(),
                DeleteAction::make()
                    ->iconButton(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
