<?php

namespace App\Filament\Admin\Resources\PropertyLeads\Pages;

use App\Filament\Admin\Resources\PropertyLeads\PropertyLeadResource;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditPropertyLead extends EditRecord
{
    protected static string $resource = PropertyLeadResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function getRedirectUrl(): string
    {
        // Esto redirige a la página de listado
        return $this->getResource()::getUrl('index');
    }
}
