<?php

namespace App\Filament\Admin\Resources\SectionFourLefts\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Filament\Schemas\Schema;

class SectionFourLeftForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('icon')
                    ->label('Icono')
                    ->required(),
                TextInput::make('title')
                    ->label('Título')
                    ->required(),
                TextInput::make('description')
                    ->label('Descripción')
                    ->required(),
                FileUpload::make('imageone')
                    ->label('Imagen Uno')
                    ->image()
                    ->required(),
                FileUpload::make('imagetwo')
                    ->label('Imagen Dos')
                    ->image()
                    ->required(),
                FileUpload::make('imagethree')
                    ->label('Imagen Tres')
                    ->image()
                    ->required(),
            ]);
    }
}
