<?php

namespace App\Filament\Admin\Resources\SectionFourRights\Pages;

use App\Filament\Admin\Resources\SectionFourRights\SectionFourRightResource;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditSectionFourRight extends EditRecord
{
    protected static string $resource = SectionFourRightResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function getRedirectUrl(): string
    {
        // Esto redirige a la página de listado
        return $this->getResource()::getUrl('index');
    }
}
