<?php

namespace App\Filament\Admin\Resources\SectionFourTitles;

use App\Filament\Admin\Resources\SectionFourTitles\Pages\CreateSectionFourTitle;
use App\Filament\Admin\Resources\SectionFourTitles\Pages\EditSectionFourTitle;
use App\Filament\Admin\Resources\SectionFourTitles\Pages\ListSectionFourTitles;
use App\Filament\Admin\Resources\SectionFourTitles\Schemas\SectionFourTitleForm;
use App\Filament\Admin\Resources\SectionFourTitles\Tables\SectionFourTitlesTable;
use App\Models\SectionFourTitle;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class SectionFourTitleResource extends Resource
{
    protected static ?string $model = SectionFourTitle::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedDocumentText   ;

    protected static string|UnitEnum|null $navigationGroup  = 'Inicio';
    protected static ?string $navigationLabel = 'Sección Cuatro - Título';
    protected static ?int    $navigationSort  = 7;    

    public static function getPluralLabel(): string
    {
        return 'Sección cuatro título';
    }

    public static function getLabel(): string
    {
        return 'Sección cuatro título';
    }

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return SectionFourTitleForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return SectionFourTitlesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListSectionFourTitles::route('/'),
            'create' => CreateSectionFourTitle::route('/create'),
            'edit' => EditSectionFourTitle::route('/{record}/edit'),
        ];
    }
}
