<?php

namespace App\Filament\Admin\Resources\TextSectionthrees;

use App\Filament\Admin\Resources\TextSectionthrees\Pages\CreateTextSectionthree;
use App\Filament\Admin\Resources\TextSectionthrees\Pages\EditTextSectionthree;
use App\Filament\Admin\Resources\TextSectionthrees\Pages\ListTextSectionthrees;
use App\Filament\Admin\Resources\TextSectionthrees\Schemas\TextSectionthreeForm;
use App\Filament\Admin\Resources\TextSectionthrees\Tables\TextSectionthreesTable;
use App\Models\TextSectionthree;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class TextSectionthreeResource extends Resource
{
    protected static ?string $model = TextSectionthree::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedDocumentText;

    protected static string|UnitEnum|null $navigationGroup  = 'Inicio';
    protected static ?string $navigationLabel = 'Sección Tres - Texto';
    protected static ?int    $navigationSort  = 4;

    protected static ?string $recordTitleAttribute = 'name';

    public static function getPluralLabel(): string
    {
        return 'Texto sección tres';
    }

    public static function getLabel(): string
    {
        return 'Texto sección tres';
    }

    public static function form(Schema $schema): Schema
    {
        return TextSectionthreeForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return TextSectionthreesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListTextSectionthrees::route('/'),
            'create' => CreateTextSectionthree::route('/create'),
            'edit' => EditTextSectionthree::route('/{record}/edit'),
        ];
    }
}
