<?php

namespace App\Filament\Admin\Resources\TypeProperties;

use App\Filament\Admin\Resources\TypeProperties\Pages\CreateTypeProperty;
use App\Filament\Admin\Resources\TypeProperties\Pages\EditTypeProperty;
use App\Filament\Admin\Resources\TypeProperties\Pages\ListTypeProperties;
use App\Filament\Admin\Resources\TypeProperties\Schemas\TypePropertyForm;
use App\Filament\Admin\Resources\TypeProperties\Tables\TypePropertiesTable;
use App\Models\TypeProperty;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class TypePropertyResource extends Resource
{
    protected static ?string $model = TypeProperty::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedListBullet;



    protected static string|UnitEnum|null $navigationGroup  = 'Inmuebles';
    protected static ?int    $navigationSort  = 1;

    public static function getPluralLabel(): string
    {
        return 'Tipos de Inmuebles';
    }

    public static function getLabel(): string
    {
        return 'Tipo de Inmueble';
    }

    public static function form(Schema $schema): Schema
    {
        return TypePropertyForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return TypePropertiesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListTypeProperties::route('/'),
            'create' => CreateTypeProperty::route('/create'),
            'edit' => EditTypeProperty::route('/{record}/edit'),
        ];
    }
}
