<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Property;
use Illuminate\Http\Request;

class PropertyExternalController extends Controller
{
    /**
     * Obtener lista de características (para AJAX)
     */
    public function list(Property $property)
    {
        $characteristics = $property->externalCharacteristics()
            ->select('external_characteristics.id', 'external_characteristics.name')
            ->get();
            
        return response()->json($characteristics);
    }

    /**
     * Agregar una característica interna (AJAX)
     */
    public function store(Request $request, Property $property)
    {
        $request->validate([
            'external_id' => 'required|exists:external_characteristics,id',
        ]);

        // Verificar si ya existe
        $exists = $property->externalCharacteristics()
            ->where('external_id', $request->external_id)
            ->exists();

        if ($exists) {
            return response()->json([
                'message' => 'Esta característica ya está asignada'
            ], 422);
        }

        // Agregar la relación
        $property->externalCharacteristics()->attach($request->external_id);

        return response()->json([
            'message' => 'Característica agregada correctamente'
        ]);
    }

    /**
     * Eliminar una característica interna (AJAX)
     */
    public function destroy(Property $property, $external)
    {
        $property->externalCharacteristics()->detach($external);

        return response()->json([
            'message' => 'Característica eliminada correctamente'
        ]);
    }
}
