<?php

namespace App\Http\Controllers;

use App\Mail\PropertyLeadClientMail;
use App\Mail\PropertyLeadCompanyMail;
use App\Models\PropertyLead;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class PropertyLeadController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'name'        => 'required|string|max:255',
            'phone'       => 'required|string|max:20',
            'email'       => 'required|email|max:255',
            'message'     => 'nullable|string',
            'visit_date'  => 'required|date|after:today',
            'property_id' => 'required|exists:properties,id',
            'agent_id'    => 'required|exists:agents,id',
        ]);

        $lead = PropertyLead::create([
            ...$request->all(),
            'status' => 'pendiente',
        ]);

        // Correo a la empresa
        Mail::to('betty.bello@confinca.com.co')->send(new PropertyLeadCompanyMail($lead));

        // Correo al cliente
        Mail::to($lead->email)->send(new PropertyLeadClientMail($lead));

        return back()->with('success', '¡Mensaje enviado! En breve nos pondremos en contacto contigo.');
    }
}