<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use App\Models\Property;

class ExternalCharacteristics extends Model
{
    protected $fillable = [
        'name',
    ];

    public function properties(): BelongsToMany
    {
        return $this->belongsToMany(
            Property::class,
            'property_external',
            'external_id',
            'property_id'
        )->withTimestamps();
    }
    
}
