<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use App\Models\Owner;
use App\Models\Agent;
use App\Models\PropertyStatus;
use App\Models\Offer;
use App\Models\TypeProperty;
use App\Models\City;
use App\Models\Neighborhood;
use App\Models\InternalCharacteristics; 
use App\Models\ExternalCharacteristics;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Property extends Model
{
    protected $fillable = [
        'code',
        'state',
        'property_status_id',
        'offer_id',
        'type_property_id',
        'agent_id',
        'price',
        'administration',
        'rooms',
        'bathrooms',
        'parking',
        'area',
        'city_id',
        'neighborhood_id',
        'address',
        'address_extra',
        'latitude',
        'longitude',
        'description',
        'owner_id',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'area' => 'decimal:2',
        'administration' => 'decimal:2',
        'rooms' => 'integer',
        'bathrooms' => 'integer',
        'parking' => 'integer',
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8',
    ];

    public function owner()
    {
        return $this->belongsTo(Owner::class);
    }

    public function agent()
    {
        return $this->belongsTo(Agent::class);
    }

    public function propertyStatus()
    {
        return $this->belongsTo(PropertyStatus::class);
    }

    public function offer()
    {
        return $this->belongsTo(Offer::class);
    }   

    public function typeProperty()
    {
        return $this->belongsTo(TypeProperty::class);
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function neighborhood()
    {
        return $this->belongsTo(Neighborhood::class);
    }

    
    public function internalCharacteristics(): BelongsToMany
    {
        return $this->belongsToMany(
            InternalCharacteristics::class,
            'property_internal',    // tabla pivot
            'property_id',          // FK de Property en pivot
            'internal_id'           // FK de InternalCharacteristics en pivot
        );
    }

    // Relación: Características Externas (muchos a muchos)
    public function externalCharacteristics(): BelongsToMany
    {
        return $this->belongsToMany(
            ExternalCharacteristics::class,
            'property_external',    // tabla pivot
            'property_id',          // FK de Property en pivot
            'external_id'           // FK de InternalCharacteristics en pivot
        );
    }

    public function images()
    {
        return $this->hasMany(PropertyImage::class)->orderBy('level');
    }

}
