<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PropertyLead extends Model
{
    protected $fillable = [
        'name', 'phone', 'email', 'message',
        'visit_date', 'status', 'property_id', 'agent_id'
    ];

    protected $casts = [
        'visit_date' => 'datetime',
    ];

    public function property()
    {
        return $this->belongsTo(Property::class);
    }

    public function agent()
    {
        return $this->belongsTo(Agent::class);
    }
}
