<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\AboutSectionFinal;
use Illuminate\Auth\Access\HandlesAuthorization;

class AboutSectionFinalPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:AboutSectionFinal');
    }

    public function view(AuthUser $authUser, AboutSectionFinal $aboutSectionFinal): bool
    {
        return $authUser->can('View:AboutSectionFinal');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:AboutSectionFinal');
    }

    public function update(AuthUser $authUser, AboutSectionFinal $aboutSectionFinal): bool
    {
        return $authUser->can('Update:AboutSectionFinal');
    }

    public function delete(AuthUser $authUser, AboutSectionFinal $aboutSectionFinal): bool
    {
        return $authUser->can('Delete:AboutSectionFinal');
    }

    public function restore(AuthUser $authUser, AboutSectionFinal $aboutSectionFinal): bool
    {
        return $authUser->can('Restore:AboutSectionFinal');
    }

    public function forceDelete(AuthUser $authUser, AboutSectionFinal $aboutSectionFinal): bool
    {
        return $authUser->can('ForceDelete:AboutSectionFinal');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:AboutSectionFinal');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:AboutSectionFinal');
    }

    public function replicate(AuthUser $authUser, AboutSectionFinal $aboutSectionFinal): bool
    {
        return $authUser->can('Replicate:AboutSectionFinal');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:AboutSectionFinal');
    }

}