<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\BannerAbout;
use Illuminate\Auth\Access\HandlesAuthorization;

class BannerAboutPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:BannerAbout');
    }

    public function view(AuthUser $authUser, BannerAbout $bannerAbout): bool
    {
        return $authUser->can('View:BannerAbout');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:BannerAbout');
    }

    public function update(AuthUser $authUser, BannerAbout $bannerAbout): bool
    {
        return $authUser->can('Update:BannerAbout');
    }

    public function delete(AuthUser $authUser, BannerAbout $bannerAbout): bool
    {
        return $authUser->can('Delete:BannerAbout');
    }

    public function restore(AuthUser $authUser, BannerAbout $bannerAbout): bool
    {
        return $authUser->can('Restore:BannerAbout');
    }

    public function forceDelete(AuthUser $authUser, BannerAbout $bannerAbout): bool
    {
        return $authUser->can('ForceDelete:BannerAbout');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:BannerAbout');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:BannerAbout');
    }

    public function replicate(AuthUser $authUser, BannerAbout $bannerAbout): bool
    {
        return $authUser->can('Replicate:BannerAbout');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:BannerAbout');
    }

}