<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\BannerHome;
use Illuminate\Auth\Access\HandlesAuthorization;

class BannerHomePolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:BannerHome');
    }

    public function view(AuthUser $authUser, BannerHome $bannerHome): bool
    {
        return $authUser->can('View:BannerHome');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:BannerHome');
    }

    public function update(AuthUser $authUser, BannerHome $bannerHome): bool
    {
        return $authUser->can('Update:BannerHome');
    }

    public function delete(AuthUser $authUser, BannerHome $bannerHome): bool
    {
        return $authUser->can('Delete:BannerHome');
    }

    public function restore(AuthUser $authUser, BannerHome $bannerHome): bool
    {
        return $authUser->can('Restore:BannerHome');
    }

    public function forceDelete(AuthUser $authUser, BannerHome $bannerHome): bool
    {
        return $authUser->can('ForceDelete:BannerHome');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:BannerHome');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:BannerHome');
    }

    public function replicate(AuthUser $authUser, BannerHome $bannerHome): bool
    {
        return $authUser->can('Replicate:BannerHome');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:BannerHome');
    }

}