<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\ColumnsSectionTwo;
use Illuminate\Auth\Access\HandlesAuthorization;

class ColumnsSectionTwoPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:ColumnsSectionTwo');
    }

    public function view(AuthUser $authUser, ColumnsSectionTwo $columnsSectionTwo): bool
    {
        return $authUser->can('View:ColumnsSectionTwo');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:ColumnsSectionTwo');
    }

    public function update(AuthUser $authUser, ColumnsSectionTwo $columnsSectionTwo): bool
    {
        return $authUser->can('Update:ColumnsSectionTwo');
    }

    public function delete(AuthUser $authUser, ColumnsSectionTwo $columnsSectionTwo): bool
    {
        return $authUser->can('Delete:ColumnsSectionTwo');
    }

    public function restore(AuthUser $authUser, ColumnsSectionTwo $columnsSectionTwo): bool
    {
        return $authUser->can('Restore:ColumnsSectionTwo');
    }

    public function forceDelete(AuthUser $authUser, ColumnsSectionTwo $columnsSectionTwo): bool
    {
        return $authUser->can('ForceDelete:ColumnsSectionTwo');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:ColumnsSectionTwo');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:ColumnsSectionTwo');
    }

    public function replicate(AuthUser $authUser, ColumnsSectionTwo $columnsSectionTwo): bool
    {
        return $authUser->can('Replicate:ColumnsSectionTwo');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:ColumnsSectionTwo');
    }

}