<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\TextSectionTwo;
use Illuminate\Auth\Access\HandlesAuthorization;

class TextSectionTwoPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:TextSectionTwo');
    }

    public function view(AuthUser $authUser, TextSectionTwo $textSectionTwo): bool
    {
        return $authUser->can('View:TextSectionTwo');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:TextSectionTwo');
    }

    public function update(AuthUser $authUser, TextSectionTwo $textSectionTwo): bool
    {
        return $authUser->can('Update:TextSectionTwo');
    }

    public function delete(AuthUser $authUser, TextSectionTwo $textSectionTwo): bool
    {
        return $authUser->can('Delete:TextSectionTwo');
    }

    public function restore(AuthUser $authUser, TextSectionTwo $textSectionTwo): bool
    {
        return $authUser->can('Restore:TextSectionTwo');
    }

    public function forceDelete(AuthUser $authUser, TextSectionTwo $textSectionTwo): bool
    {
        return $authUser->can('ForceDelete:TextSectionTwo');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:TextSectionTwo');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:TextSectionTwo');
    }

    public function replicate(AuthUser $authUser, TextSectionTwo $textSectionTwo): bool
    {
        return $authUser->can('Replicate:TextSectionTwo');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:TextSectionTwo');
    }

}