<?php

namespace App\Providers\Filament;

use Filament\Http\Middleware\Authenticate;
use BezhanSalleh\FilamentShield\FilamentShieldPlugin;
use Filament\Http\Middleware\AuthenticateSession;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Pages\Dashboard;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Widgets\AccountWidget;
use Filament\Widgets\FilamentInfoWidget;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use Resma\FilamentAwinTheme\FilamentAwinTheme;
use Filament\Navigation\NavigationGroup;
use Filament\Navigation\NavigationItem;
use Filament\Navigation\NavigationSection;

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel        
            ->default()
            ->id('admin')
            ->path('admin')
            ->navigationGroups([ 
                NavigationGroup::make('Inicio')
                    ->collapsed(),

                NavigationGroup::make('Nosotros')
                    ->collapsed(), 
                    
                NavigationGroup::make('Inmuebles')
                    ->collapsed(), 
                
                NavigationGroup::make('Posibles Clientes')
                    ->collapsed(),    
                
                NavigationGroup::make('Agentes')
                    ->collapsed(),
                
                NavigationGroup::make('Blog')
                    ->collapsed(),

                NavigationGroup::make('Contacto')
                    ->collapsed(),            
                 
                                
                NavigationGroup::make('Seguridad')
                    ->collapsed(),
                    
            ])
            ->login()
            ->colors([
                'primary' => Color::Amber,
            ])
            // Branding
            ->brandName('Confinca')
            ->favicon(asset('images/favicon.png'))
            // Modo oscuro
            ->darkMode(true)            
            
            // Sidebar
            ->sidebarCollapsibleOnDesktop()
            ->sidebarFullyCollapsibleOnDesktop()
            ->globalSearch(false) 

            ->discoverResources(in: app_path('Filament/Admin/Resources'), for: 'App\Filament\Admin\Resources')
            ->discoverPages(in: app_path('Filament/Admin/Pages'), for: 'App\Filament\Admin\Pages')
            ->pages([
                Dashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Admin/Widgets'), for: 'App\Filament\Admin\Widgets')
            ->widgets([
                AccountWidget::class,
                //FilamentInfoWidget::class,
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->plugins([
                FilamentShieldPlugin::make(),
                FilamentAwinTheme::make(),
                FilamentShieldPlugin::make()
                    ->navigationGroup('Seguridad'),
            ])
            ->authMiddleware([
                Authenticate::class,
            ]);
    }

    
}
