<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('properties', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique();
            $table->enum('state', ['Activo', 'Inactivo'])->default('Activo');
            $table->foreignId('property_status_id')->constrained('property_statuses')->onDelete('cascade');
            $table->foreignId('offer_id')->constrained('offers')->onDelete('cascade');
            $table->foreignId('type_property_id')->constrained('type_properties')->onDelete('cascade');
            $table->foreignId('agent_id')->constrained('agents')->onDelete('cascade');
            $table->decimal('price', 22, 2);
            $table->decimal('administration', 22, 2);
            $table->string('rooms');
            $table->string('bathrooms');
            $table->string('parking');
            $table->string('area');
            $table->foreignId('city_id')->constrained('cities')->onDelete('cascade');
            $table->foreignId('neighborhood_id')->constrained('neighborhoods')->onDelete('cascade');
            $table->text('address');
            $table->string('address_extra')->nullable();
            $table->decimal('latitude', 11, 8);
            $table->decimal('longitude', 11, 8);
            $table->text('description')->nullable();
            $table->foreignId('owner_id')->constrained('owners')->onDelete('cascade');
            $table->string('video_url')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('properties');
    }
};
