<script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>
@php
$record = $getRecord();
@endphp

<div x-data="externalTableData({{ $record->id }})" class="space-y-4">

    {{-- Mensaje --}}
    <div x-show="message" 
         x-transition
         :class="messageClass"
         class="p-3 rounded-lg border text-sm"
         x-text="message">
    </div>

    {{-- Loading --}}
    <div x-show="loading" class="text-center py-8">
        <svg class="animate-spin mx-auto h-8 w-8 text-gray-400" fill="none" viewBox="0 0 24 24">
            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
        </svg>
        <p class="mt-2 text-sm text-gray-500">Cargando...</p>
    </div>

    {{-- Empty state --}}
    <div x-show="!loading && characteristics.length === 0" class="text-center py-12 px-6 bg-gray-50 rounded-lg border border-dashed border-gray-300">
        <svg class="mx-auto h-12 w-12 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
        </svg>
        <h3 class="mt-2 text-sm font-medium text-gray-900">Sin características</h3>
        <p class="mt-1 text-sm text-gray-500">No hay características externas asignadas.</p>
    </div>

    {{-- Tabla --}}
    <div x-show="!loading && characteristics.length > 0" class="overflow-hidden rounded-lg border border-gray-200 shadow-sm">
        <table class="w-full text-sm text-left">
            <thead class="text-xs text-gray-700 uppercase bg-gray-100">
                <tr>
                    <th scope="col" class="px-6 py-3 font-semibold">ID</th>
                    <th scope="col" class="px-6 py-3 font-semibold">Nombre</th>
                    <th scope="col" class="px-6 py-3 font-semibold text-right">Acciones</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200 bg-white">
                <template x-for="char in characteristics" :key="char.id">
                    <tr class="hover:bg-gray-50 transition-colors">
                        <td class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap" x-text="'#' + char.id"></td>
                        <td class="px-6 py-4 text-gray-700" x-text="char.name"></td>
                        <td class="px-6 py-4 text-right">
                            <button type="button"
                                @click="deleteChar(char.id, char.name)"
                                :disabled="deleting === char.id"
                                class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-red-600 hover:text-white hover:bg-red-600 disabled:opacity-50 disabled:cursor-not-allowed border border-red-600 rounded-md transition-colors">
                                <svg x-show="deleting !== char.id" class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                </svg>
                                <svg x-show="deleting === char.id" class="animate-spin w-4 h-4 mr-1.5" fill="none" viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                </svg>
                                <span x-text="deleting === char.id ? 'Eliminando...' : 'Eliminar'"></span>
                            </button>
                        </td>
                    </tr>
                </template>
            </tbody>
        </table>
    </div>
    
    <div x-show="!loading && characteristics.length > 0" class="text-xs text-gray-500">
        Mostrando <span x-text="characteristics.length"></span> característica(s)
    </div>
</div>

<script>
function externalTableData(propertyId) {
    return {
        characteristics: [],
        loading: true,
        deleting: null,
        message: '',
        messageType: '',
        
        get messageClass() {
            return {
                'bg-green-50 text-green-700 border-green-200': this.messageType === 'success',
                'bg-red-50 text-red-700 border-red-200': this.messageType === 'error',
                'bg-yellow-50 text-yellow-700 border-yellow-200': this.messageType === 'warning'
            };
        },
        
        init() {
            this.loadData();
            window.addEventListener('refresh-external-table', () => {
                this.loadData();
            });
        },
        
        async loadData() {
            this.loading = true;
            try {
                const response = await fetch('/properties/' + propertyId + '/external/list');
                this.characteristics = await response.json();
            } catch (error) {
                console.error('Error:', error);
            } finally {
                this.loading = false;
            }
        },
        
        async deleteChar(id, name) {
            if (!confirm('¿Eliminar "' + name + '"?')) return;
            
            this.deleting = id;
            this.message = '';
            
            try {
                const response = await fetch('/properties/' + propertyId + '/external/' + id, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json',
                    }
                });
                
                const data = await response.json();
                
                if (response.ok) {
                    this.message = data.message || 'Eliminado correctamente';
                    this.messageType = 'success';
                    await this.loadData();
                    setTimeout(() => { this.message = ''; }, 3000);
                } else {
                    this.message = data.message || 'Error al eliminar';
                    this.messageType = 'error';
                }
            } catch (error) {
                this.message = 'Error de conexión';
                this.messageType = 'error';
            } finally {
                this.deleting = null;
            }
        }
    }
}
</script>