@extends('layouts.app')

@section('title', 'CONFINCA - Noticias')

@section('content')

                <!-- flat-title -->
                <div class="pt-150 ">
                    <div class="flat-title">
                        <div class="cl-container full">
                            <div class="row">
                                <div class="col-12">
                                    <div class="content">
                                        <h2>Noticias</h2>
                                        <ul class="breadcrumbs">
                                            <li>Noticias del sector inmobiliario</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> 
                </div>
                <!-- /flat-title -->

                <!-- widget-tabs -->
                <div>
                    
                    <div class="widget-content-tab">
                        <div class="widget-content-inner">
                            <!-- grid-blog -->
                            <div class="cl-container">
                                <div class="row">
                                    @foreach ($posts as $post)  
                                        <div class="col-xl-4 col-md-6 col-12">
                                            <div class="wg-blog">
                                                <div class="image">
                                                    <img src="{{ asset('storage/' . $post->cover_image) }}" alt="">
                                                </div>
                                                <div class="content">
                                                    <div class="sub-blog">
                                                        <div>{{ $post->title }}</div>
                                                        <div>{{ date('F j, Y', strtotime($post->published_at)) }}</div>
                                                    </div>
                                                    <div class="name">
                                                        <a href="{{ route('detailpost', $post->slug) }}">{{ $post->excerpt }}</a>
                                                    </div>
                                                    <a href="{{ route('detailpost', $post->slug) }}" class="tf-button-no-bg">
                                                        Leer más
                                                        <i class="icon-arrow-right-add"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                    
                                    <!-- Links de paginación con Bootstrap -->
                                    @if ($posts->hasPages())
                                        <div class="col-12 mb-50">
                                            <ul class="wg-pagination justify-center wow fadeInUp">
                                                @if ($posts->onFirstPage())
                                                    <li class="disabled">
                                                        <span><i class="icon-keyboard_arrow_left"></i></span>
                                                    </li>
                                                @else
                                                    <li>
                                                        <a href="{{ $posts->previousPageUrl() }}" rel="prev">
                                                            <i class="icon-keyboard_arrow_left"></i>
                                                        </a>
                                                    </li>
                                                @endif

                                                @foreach ($posts->links()->elements[0] as $page => $url)
                                                    @if ($page == $posts->currentPage())
                                                        <li class="active"><a href="{{ $url }}">{{ $page }}</a></li>
                                                    @else
                                                        <li><a href="{{ $url }}">{{ $page }}</a></li>
                                                    @endif
                                                @endforeach
                                                @if ($posts->hasMorePages())
                                                    <li>
                                                        <a href="{{ $posts->nextPageUrl() }}" rel="next">
                                                            <i class="icon-keyboard_arrow_right"></i>
                                                        </a>
                                                    </li>
                                                @else
                                                    <li class="disabled">
                                                        <span><i class="icon-keyboard_arrow_right"></i></span>
                                                    </li>
                                                @endif
                                            </ul>
                                        </div>
                                    @endif
                                </div>    
                            </div>
                        </div>                        
                    </div>
                </div>            

@endsection