<?php $__env->startSection('title', 'CONFINCA - Ventas'); ?>
<?php $__env->startSection('content'); ?>

<div class="main-content pt-150">
    <div class="flat-title">
        <div class="cl-container full">
            <div class="row">
                <div class="col-12">
                    <div class="content">
                        <h2>Inmuebles en Arriendo</h2>
                        <ul class="breadcrumbs">
                            <li><a href="<?php echo e(route('welcome')); ?>">Inicio</a></li>
                            <li>/</li>
                            <li>Listado de inmuebles</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="property-list-wrap v1">
        <div class="cl-container">
            <div class="row">
                
                <div class="col-lg-4">
                    <form class="form-sidebar-left" method="GET" action="<?php echo e(route('rent')); ?>">
                        <h4>Buscar Inmueble</h4>

                        <div class="wow fadeInUp mb-3" style="z-index:1000">
                            <h6>Tipo de Inmueble</h6>
                            <select name="type" class="w-full">
                                <option value="">Todos</option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type->id); ?>" <?php echo e(request('type') == $type->id ? 'selected' : ''); ?>>
                                        <?php echo e($type->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>

                        <div class="wow fadeInUp mb-3" style="z-index:900">
                            <h6>Habitaciones</h6>
                            <select name="rooms" class="w-full">
                                <option value="">Todas</option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = [1,2,3,4,5]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($n); ?>" <?php echo e(request('rooms') == $n ? 'selected' : ''); ?>><?php echo e($n); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>

                        <div class="wow fadeInUp mb-3" style="z-index:800">
                            <h6>Baños</h6>
                            <select name="bathrooms" class="w-full">
                                <option value="">Todos</option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = [1,2,3,4,5]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($n); ?>" <?php echo e(request('bathrooms') == $n ? 'selected' : ''); ?>><?php echo e($n); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>

                        <div class="wow fadeInUp mb-3" style="z-index:700">
                            <h6>Ciudad</h6>
                            <select name="city" class="w-full" onchange="this.form.submit()">
                                <option value="">Todas</option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($city->id); ?>" <?php echo e(request('city') == $city->id ? 'selected' : ''); ?>>
                                        <?php echo e($city->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($neighborhoods->count()): ?>
                        <div class="wow fadeInUp mb-3" style="z-index:600">
                            <h6>Barrio</h6>
                            <select name="neighborhood" class="w-full">
                                <option value="">Todos</option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $neighborhoods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $neighborhood): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($neighborhood->id); ?>" <?php echo e(request('neighborhood') == $neighborhood->id ? 'selected' : ''); ?>>
                                        <?php echo e($neighborhood->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <div class="grid-2-cols wow fadeInUp mb-3">
                            <fieldset>
                                <input type="number" name="min_price" placeholder="Precio mínimo"
                                       value="<?php echo e(request('min_price')); ?>">
                            </fieldset>
                            <fieldset>
                                <input type="number" name="max_price" placeholder="Precio máximo"
                                       value="<?php echo e(request('max_price')); ?>">
                            </fieldset>
                            <fieldset>
                                <input type="number" name="min_area" placeholder="Área mínima m²"
                                       value="<?php echo e(request('min_area')); ?>">
                            </fieldset>
                            <fieldset>
                                <input type="number" name="max_area" placeholder="Área máxima m²"
                                       value="<?php echo e(request('max_area')); ?>">
                            </fieldset>
                        </div>

                        <button type="submit" class="tf-button-primary w-full wow fadeInUp">
                            Buscar Inmueble <i class="icon-arrow-right-add"></i>
                        </button>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(request()->hasAny(['type','rooms','bathrooms','city','neighborhood','min_price','max_price','min_area','max_area'])): ?>
                            <a href="<?php echo e(route('sale')); ?>" class="tf-button-other w-full wow fadeInUp mt-2">
                                Limpiar filtros
                            </a>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </form>
                </div>

                
                <div class="col-lg-8">
                    <div class="top">
                        <div class="sub">
                            <p><?php echo e($rent->total()); ?> <?php echo e($rent->total() == 1 ? 'Resultado' : 'Resultados'); ?></p>
                        </div>
                    </div>

                    <div class="row">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $rent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inmueble): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="col-xl-6">
                            <div class="box-dream has-border wow fadeInUp">
                                <div class="image">
                                    <div class="list-tags">
                                        <a href="<?php echo e(route('property.show', $inmueble->id)); ?>" class="tags-item for-sell">
                                            <?php echo e($inmueble->offer->name); ?>

                                        </a>
                                    </div>
                                    <div class="swiper-container slider-box-dream arrow-style-1 pagination-style-1">
                                        <div class="swiper-wrapper">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $inmueble->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="swiper-slide">
                                                <img src="<?php echo e(Storage::url($image->image)); ?>" alt="">
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                        <div class="swiper-pagination box-dream-pagination"></div>
                                        <div class="box-dream-next swiper-button-next"></div>
                                        <div class="box-dream-prev swiper-button-prev"></div>
                                    </div>
                                </div>
                                <div class="content">
                                    <div class="head">
                                        <div class="title">
                                            <a href="<?php echo e(route('property.show', $inmueble->id)); ?>">
                                                <?php echo e($inmueble->typeProperty->name); ?>

                                            </a>
                                        </div>
                                        <div class="price">$<?php echo e(number_format($inmueble->price)); ?></div>
                                    </div>
                                    <div class="location">
                                        <div class="icon"><i class="flaticon-location"></i></div>
                                        <p><?php echo e($inmueble->address); ?></p>
                                    </div>
                                    <div class="icon-box">
                                        <div class="item">
                                            <i class="flaticon-hotel"></i>
                                            <p><?php echo e($inmueble->rooms); ?> Hab.</p>
                                        </div>
                                        <div class="item">
                                            <i class="flaticon-bath-tub"></i>
                                            <p><?php echo e($inmueble->bathrooms); ?> Baños</p>
                                        </div>
                                        <div class="item">
                                            <i class="flaticon-minus-front"></i>
                                            <p><?php echo e($inmueble->area); ?> m²</p>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="head">
                                        <div class="title">
                                            <a href="https://wa.me/57<?php echo e($inmueble->agent->phone); ?>?text=Hola, estoy interesado en la propiedad: <?php echo e(urlencode($inmueble->code)); ?>"" class="tf-button-primary" type="submit">Me Interesa <i class="flaticon-whatsapp"></i></a>
                                        </div>
                                        <div class="title">
                                            <a href="<?php echo e(route('property.show', $inmueble->id)); ?>" class="tf-button-primary" type="submit">Ver Detalles <i class="icon-arrow-right-add"></i></a>
                                        </div>
                                                            
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-12">
                                <p>No hay inmuebles para mostrar.</p>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($rent->hasPages()): ?>
                    <div class="row">
                        <div class="col-12">
                            <ul class="wg-pagination justify-center wow fadeInUp">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($rent->onFirstPage()): ?>
                                    <li class="disabled"><span><i class="icon-keyboard_arrow_left"></i></span></li>
                                <?php else: ?>
                                    <li>
                                        <a href="<?php echo e($rent->previousPageUrl()); ?>" rel="prev">
                                            <i class="icon-keyboard_arrow_left"></i>
                                        </a>
                                    </li>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $rent->links()->elements[0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($page == $rent->currentPage()): ?>
                                        <li class="active"><span><?php echo e($page); ?></span></li>
                                    <?php else: ?>
                                        <li><a href="<?php echo e($url); ?>"><?php echo e($page); ?></a></li>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($rent->hasMorePages()): ?>
                                    <li>
                                        <a href="<?php echo e($rent->nextPageUrl()); ?>" rel="next">
                                            <i class="icon-keyboard_arrow_right"></i>
                                        </a>
                                    </li>
                                <?php else: ?>
                                    <li class="disabled"><span><i class="icon-keyboard_arrow_right"></i></span></li>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/confinca/resources/views/propertyRent.blade.php ENDPATH**/ ?>